unit TransferFormUnit;
{
    UNIT TransferFormUnit;
    Version number 1.0.

This unit contains 'pBoy's YAFTP > Transfer' form and it's handling routines.
Notes:
     * calculations with transfer speed are not really exact... but I haven't
       found a better way to get number of seconds from a TDateTime structure.

Created by Pter Karsai, 3rd, 4th of August '99. Now it's 1:02am :) ... I'm
listenin' to The Doors - and I feel fine.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls;

{ form TTransferForm class declaration }
type
  TTransferForm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel; Label2: TLabel; Label3: TLabel; Label4: TLabel;
    Label6: TLabel; Label7: TLabel; Label8: TLabel; Label9: TLabel;
    Label5: TLabel;
    TransferProgressBar: TProgressBar;
    TransferAnimate   : TAnimate;  ConnectingAnimate : TAnimate;
    AbortButton : TButton; HelpButton : TButton; MinimizeButton : TButton;
    TerminateB  : TButton;
    LocalFileL     : TLabel;  RemoteFileL    : TLabel;
    FileSizeL      : TLabel;  TransferModeL  : TLabel;
    ElapsedTimeL   : TLabel;  EstimatedTimeL : TLabel;
    TimeLeftL      : TLabel;  TransferSpeedL : TLabel;
    PercentL       : TLabel;  TransBytesL    : TLabel;
    InfoTimer      : TTimer;

{ event handlers }
    procedure MinimizeButtonClick(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
    procedure AbortButtonClick(Sender: TObject);
    procedure InfoTimerTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TerminateBClick(Sender: TObject);

{ internal data }
  private
    LocalFileName : AnsiString;  { local file name }
    RemoteFileName: AnsiString;  { remote file name }
    FileSizeBytes : longint;     { file size in bytes }
    AlreadyBytes  : longint;     { bytes already transfered. (REST or APPE) }
    TransferType  : string;      { download or upload }
    StartTime     : TDateTime;   { time when operation started }
    WouldClose    : boolean;     { TRUE if Abor key pressed () }
  public
    procedure SetTransferInfo(IsDownload, IsBinary: boolean);
{ Eh. I hate to type twice. This machine has crashed and two hours of my work
  gone to the air! You say, I'm stupid, why I haven't saved more frequently...
  I saved in each 10 minutes! But the Delphi3-4 uses interesting buffer tech :(}

    procedure SetFileInfo(LFName, RFName: string; FSize, BGot: longint);
{ Function: set and show file information. LFName -> local file name, RFName ->
  remote file name, FSize -> file size, BGot -> bytes already transfered. }

    procedure ShowProgress(CurrentBytes: longint);
{ Function: calculate all time-dependent data and show them. }

    procedure Connecting;
{ Function: shows common-AVI FindComputer }

    procedure Transferring;
{ Function: shows common-AVI CopyFile. Moreover it initialize the internal time
  used for transfer calculations. }

    procedure CloseForm;
{ Function: close form }

  end;

var
  TransferForm: TTransferForm;

implementation
uses FTPFormUnit;
{$R *.DFM}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------ TTransferForm class event handlers and other methods ------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
procedure TTransferForm.SetTransferInfo(IsDownload, IsBinary: boolean);
begin
{ save data and show transfer mode }
    if IsDownload then TransferType:= 'downloading'
       else TransferType:= 'uploading';
    if IsBinary then TransferModeL.Caption:= 'binary'
       else TransferModeL.Caption:= 'ASCII [text]';
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.SetFileInfo(LFName,RFName: string; FSize, BGot:longint);
begin
{ save all incoming data }
    LocalFileName  := LFName;
    RemoteFileName := RFName;
    FileSizeBytes  := FSize;
    AlreadyBytes   := BGot;

{ show available information }
    LocalFileL.Caption  := LocalFileName;
    RemoteFileL.Caption := RemoteFileName;
    FileSizeL.Caption   := Format('%d bytes', [FileSizeBytes]);
    TransBytesL.Caption := Format('%d tot / 0 cur', [AlreadyBytes]);
    TransferForm.Caption:= Format('YAFTP %s of %s', [TransferType,
                                   RemoteFileName]);
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.ShowProgress(CurrentBytes: longint);
var percentsComp : byte;       { percents currently completed }
    tempTime     : TDateTime;  { temporary time value }
begin
{ show current transfer - in bytes }
    TransBytesL.Caption := Format('%d tot / %d cur',
                                  [AlreadyBytes + CurrentBytes, CurrentBytes]);
{ calculate percents completed }
    percentsComp:= round((AlreadyBytes + CurrentBytes) / FileSizeBytes * 100);
    PercentL.Caption:= IntToStr(percentsComp) + '%';
    TransferProgressBar.Position:= percentsComp;
    TransferForm.Caption:= Format('YAFTP [%d%%] %s of %s', [percentsComp,
                                  TransferType, RemoteFileName]);
{ calculate time values }
    tempTime:= Time - startTime;  { elapsed time }
    ElapsedTimeL.Caption:= TimeToStr(tempTime);
    EstimatedTimeL.Caption:= TimeToStr(tempTime / (CurrentBytes + 1)
                                       * FileSizeBytes);
    TimeLeftL.Caption:= TimeToStr(tempTime - tempTime / (CurrentBytes + 1)*
                                  FileSizeBytes);
{ calculate transfer speed }
    TransferSpeedL.Caption:= FormatFloat('#,##0.00', CurrentBytes / 1024 /
                                         (tempTime * 100 / 0.0011574074074)) +
                                         ' Kb/s';
    { 0.0011574074074 = 100/24/60/60. It's equal to one second in TDateTime
      structure. }
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.Connecting;
begin
    AbortButton.Enabled:= false;
    TerminateB.Enabled:= false;

    WouldClose:= false;

{ reset unwant data on screen }
    TransBytesL.Caption:= ''; PercentL.Caption:= ''; TimeLeftL.Caption:= '';
    TransferProgressBar.Position:= 0;
    ElapsedTimeL.Caption:= ''; EstimatedTimeL.Caption:= '';
    TransferSpeedL.Caption:= '';

{ start play AVI }
    TransferAnimate.Visible:= false;
    with ConnectingAnimate do begin
       Visible:= true;
       Play(StartFrame, StopFrame, 0);
    end;
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.Transferring;
begin
    AbortButton.Enabled:= true;
    TerminateB.Enabled:= true;
{ start play AVI }
    ConnectingAnimate.Visible:= false;
    with TransferAnimate do begin
       Visible:= true;
       Play(StartFrame, StopFrame, 0);
    end;
{ save current time for later calculations }
    StartTime:= Time;
{ start InfoTimer }
    InfoTimer.Enabled:= true;
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.MinimizeButtonClick(Sender: TObject);
begin
    Application.Minimize;
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.HelpButtonClick(Sender: TObject);
begin
    Application.HelpCommand(HELP_CONTEXT, $47); { TransferWinInfo }
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.AbortButtonClick(Sender: TObject);
begin
    FTPFTools.XFTPSession.Abort;
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.InfoTimerTimer(Sender: TObject);
var totBytes, curBytes: longint;  { total / current transfered bytes }
begin
    FTPFTools.XFTPSession.GetTransferInfo(totBytes, curBytes);
    ShowProgress(curBytes);
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
{ if it's an user-call, don't let close window, but start Abort process }
    if not WouldClose then begin
       Action:= caNone;
       if InfoTimer.Enabled then FTPFTools.XFTPSession.Abort;
    end
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.TerminateBClick(Sender: TObject);
begin
    FTPFTools.XFTPSession.TerminateTransfer;
end;

{------------------------------------------------------------------------------}

procedure TTransferForm.CloseForm;
begin
    InfoTimer.Enabled:= false;
    WouldClose:= true;
    Close;
end;

{------------------------------------------------------------------------------}

end.
